/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.tasks;

import com.ibm.hwmca.fw.attn.Attention;
import com.ibm.hwmca.fw.attn.AttentionID;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.xfw.pa.tasks.PanelHandler;
import com.ibm.hwmca.xfw.panel.pa.primary.CustomerContactInformationBean;
import com.ibm.hwmca.xfw.panel.pa.primary.DetailsBean;
import com.ibm.hwmca.xfw.panel.pa.primary.ManualCallHomeBean;
import com.ibm.hwmca.xfw.panel.pa.primary.PAPanelBean;
import com.ibm.hwmca.xfw.panel.pa.primary.PAPanelLIRBean;
import com.ibm.hwmca.xfw.panel.pa.primary.PECEBean;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Stack;

public abstract class XFramePrimaryProblemAnalysisServerTasklet
extends HwmcaPanelTasklet {
    private static final String UNKNOWN_BUTTON = "Internal error: An action from an unknown button was received: ";
    private static final String DISABLED_BUTTON = "Internal error: An action from a button that should be disabled was received.";
    private static final String BAD_BEAN = "Internal error: An unexpected type of panel bean was returned from the tower.";
    private PanelHandler panelHandlerPAPanel = new InitialPanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            String actionCommand = ((TaskActionEvent)request.getData("event")).getActionCommand();
            if (actionCommand.endsWith("DisplaySenseButon")) {
                DetailsBean daBean = XFramePrimaryProblemAnalysisServerTasklet.this.getDetailsBean();
                if (daBean != null) {
                    response.openModalChild("com.ibm.hwmca.xfw.panel.pa.res.ProblemAnalysisRes", "TypeFourPanel", daBean);
                    XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerDetails);
                } else {
                    response.noAction();
                }
            } else {
                super.service(request, response);
            }
        }
    };
    private PanelHandler panelHandlerPAPanelLIR = new InitialPanelHandler();
    private PanelHandler panelHandlerDetails = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            String actionCommand = ((TaskActionEvent)request.getData("event")).getActionCommand();
            if (actionCommand.endsWith("OkButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.pop();
                response.dispose();
            } else {
                response.error(new LocalizableText(XFramePrimaryProblemAnalysisServerTasklet.UNKNOWN_BUTTON + actionCommand), null);
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerErrorHandler);
            }
        }
    };
    private PanelHandler panelHandlerCustomerContactInfo = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            String actionCommand = ((TaskActionEvent)request.getData("event")).getActionCommand();
            if (actionCommand.endsWith("RequestServiceButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.requestService(request);
                response.terminate();
            } else if (actionCommand.endsWith("CancelButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.pop();
                response.dispose();
            } else {
                response.error(new LocalizableText(XFramePrimaryProblemAnalysisServerTasklet.UNKNOWN_BUTTON + actionCommand), null);
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerErrorHandler);
            }
        }
    };
    private PanelHandler panelHandlerManualCallHome = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            String actionCommand = ((TaskActionEvent)request.getData("event")).getActionCommand();
            if (actionCommand.endsWith("OkButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.manualCallHomeAcknowledged();
                response.terminate();
            } else if (actionCommand.endsWith("CancelButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.pop();
                response.dispose();
            } else {
                response.error(new LocalizableText(XFramePrimaryProblemAnalysisServerTasklet.UNKNOWN_BUTTON + actionCommand), null);
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerErrorHandler);
            }
        }
    };
    private PanelHandler panelHandlerPECE = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            String actionCommand = ((TaskActionEvent)request.getData("event")).getActionCommand();
            if (actionCommand.endsWith("OkButton")) {
                response.terminate();
            } else if (actionCommand.endsWith("DeleteMessageButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.deleteMessage();
                response.terminate();
            } else if (actionCommand.endsWith("CancelButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.pop();
                response.dispose();
            } else {
                response.error(new LocalizableText(XFramePrimaryProblemAnalysisServerTasklet.UNKNOWN_BUTTON + actionCommand), null);
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerErrorHandler);
            }
        }
    };
    private PanelHandler panelHandlerErrorHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            response.terminate();
        }
    };
    private Stack panelHandlers = new Stack();
    protected Attention attention = null;

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block9: {
            if (request.isInitialRequest()) {
                this.attention = Attention.getAttention((ObjectId)request.getData("OBJECT_ID"), (AttentionID)request.getData("ATTENTION_ID"));
                PanelBean panelBean = this.getPAPanelBean();
                if (panelBean instanceof PAPanelBean) {
                    response.openModalChild("com.ibm.hwmca.xfw.panel.pa.res.ProblemAnalysisRes", "TypeThreePanel", (PAPanelBean)panelBean);
                    this.panelHandlers.push(this.panelHandlerPAPanel);
                } else if (panelBean instanceof PAPanelLIRBean) {
                    response.openModalChild("com.ibm.hwmca.xfw.panel.pa.res.ProblemAnalysisRes", "TypeSixPanel", (PAPanelLIRBean)panelBean);
                    this.panelHandlers.push(this.panelHandlerPAPanelLIR);
                } else {
                    response.error(new LocalizableText(BAD_BEAN), null);
                    this.panelHandlers.push(this.panelHandlerErrorHandler);
                }
            } else {
                try {
                    if (request.isDisposed() || request.isCanceled() || ((TaskActionEvent)request.getData("event")).getActionCommand().endsWith("CANCEL")) {
                        response.dispose();
                        this.panelHandlers.pop();
                        break block9;
                    }
                    ((PanelHandler)this.panelHandlers.peek()).service(request, response);
                }
                catch (Exception e) {
                    response.terminate();
                }
            }
        }
    }

    public abstract PanelBean getPAPanelBean() throws TaskletException;

    public abstract void noService() throws TaskletException;

    public abstract void deleteMessage() throws TaskletException;

    public abstract boolean isAdministrator() throws TaskletException;

    public abstract PECEBean getPECEBean() throws TaskletException;

    public abstract boolean isRSFEnabled() throws TaskletException;

    public abstract CustomerContactInformationBean getCustomerContactInformationBean() throws TaskletException;

    public abstract ManualCallHomeBean getManualCallHomeBean() throws TaskletException;

    public abstract DetailsBean getDetailsBean() throws TaskletException;

    public abstract void requestService(PanelTaskletRequest var1) throws TaskletException;

    public abstract void manualCallHomeAcknowledged() throws TaskletException;

    class InitialPanelHandler
    implements PanelHandler {
        InitialPanelHandler() {
        }

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            String actionCommand = ((TaskActionEvent)request.getData("event")).getActionCommand();
            if (actionCommand.endsWith("RequestServiceButton")) {
                if (XFramePrimaryProblemAnalysisServerTasklet.this.isAdministrator()) {
                    PECEBean daBean = XFramePrimaryProblemAnalysisServerTasklet.this.getPECEBean();
                    if (daBean != null) {
                        response.openModalChild("com.ibm.hwmca.xfw.panel.pa.res.ProblemAnalysisRes", "TypeNinePanel", daBean);
                        XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerPECE);
                    } else {
                        response.noAction();
                    }
                } else if (XFramePrimaryProblemAnalysisServerTasklet.this.isRSFEnabled()) {
                    CustomerContactInformationBean daBean = XFramePrimaryProblemAnalysisServerTasklet.this.getCustomerContactInformationBean();
                    if (daBean != null) {
                        response.openModalChild("com.ibm.hwmca.xfw.panel.pa.res.ProblemAnalysisRes", "TypeSevenPanel", daBean);
                        XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerCustomerContactInfo);
                    } else {
                        response.noAction();
                    }
                } else {
                    ManualCallHomeBean daBean = XFramePrimaryProblemAnalysisServerTasklet.this.getManualCallHomeBean();
                    if (daBean != null) {
                        response.openModalChild("com.ibm.hwmca.xfw.panel.pa.res.ProblemAnalysisRes", "TypeEightPanel", daBean);
                        XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerManualCallHome);
                    } else {
                        response.noAction();
                    }
                }
            } else if (actionCommand.endsWith("DeleteButton") || actionCommand.endsWith("DeleteMessageButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.deleteMessage();
                response.terminate();
            } else if (actionCommand.endsWith("NoServiceButton")) {
                XFramePrimaryProblemAnalysisServerTasklet.this.noService();
                response.terminate();
            } else if (actionCommand.endsWith("CancelButton")) {
                response.terminate();
            } else if (actionCommand.endsWith("DisplayServiceInfoButton") || actionCommand.endsWith("EsconManagerButton") || actionCommand.endsWith("DetailButton")) {
                response.error(new LocalizableText(XFramePrimaryProblemAnalysisServerTasklet.DISABLED_BUTTON), null);
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerErrorHandler);
            } else {
                response.error(new LocalizableText(XFramePrimaryProblemAnalysisServerTasklet.UNKNOWN_BUTTON + actionCommand), null);
                XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlers.push(XFramePrimaryProblemAnalysisServerTasklet.this.panelHandlerErrorHandler);
            }
        }
    }
}

